/**
* \file: AilConfiguration.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AILCONFIGURATION_H
#define CARPLAY_AILCONFIGURATION_H

#include <map>
#include <string>
#include <vector>
#include <carplay_plugin.h>

namespace adit { namespace carplay
{

class AilConfiguration
{
public:
    enum Channel
    {
        Channel_MainOut = AudioChannelType_Main /* 0 */,
        Channel_AlternateOut = AudioChannelType_Alternate /* 1 */,
        Channel_MainIn = 2,
        Channel_Count = 3
    };

    AilConfiguration();

    static AilConfiguration& Instance();

    bool IsVerboseLogging(const IConfiguration& inConfig);
    bool IsAilLogging(const IConfiguration& inConfig);
    bool GetDeviceSettings(const IConfiguration& inConfig, Channel inChannel, const std::string& inAudioType,
            AudioFormatStruct inFormat, std::string& outDeviceName, uint32_t& outPeriodMilli, int32_t& outBufferPeriods,
            int32_t& outSilenceMilli, int32_t& outInitToutMilli);

private:
    class AudioDeviceSettings
    {
    public:
        std::string     DeviceName;
        int32_t         PeriodMilli;
        int32_t         BufferPeriods;
        int32_t         SilenceMilli;
        int32_t         InitToutMilli;
        std::string     AudioType;
        int32_t         SampleRate;
        int8_t          SampleSize;
        int8_t          Channels;

        AudioDeviceSettings();
        void Dump();
    };

    static AilConfiguration* instance;

    std::vector<AudioDeviceSettings> deviceSettings[Channel_Count];
    int verbose;
    int ailLogging;

    bool parseDeviceSettings(const IConfiguration& inConfig, Channel inChannel);
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AILCONFIGURATION_H */
